<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 02.04.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Schutzbauten');
requireLogin();
requireRole(['Auswerter', 'Bearbeiter', 'Administrator']);
showSessionAlert();
initializeDatabaseConnection();

if (isset($_POST['quickSave'])) {
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'qty-shelter-') === 0) {
            // Shelter-ID extrahieren
            $shelterID = (int) str_replace('qty-shelter-', '', $key);

            // Wert prüfen und entweder in INT umwandeln oder NULL setzen
            $qty = (trim($value) === '') ? null : (int) $value;

            // SQL vorbereiten
            $update = $pdo->prepare("UPDATE Shelters SET QuickQty = :qty WHERE ID = :id");
            $update->bindValue(':qty', $qty, is_null($qty) ? PDO::PARAM_NULL : PDO::PARAM_INT);
            $update->bindValue(':id', $shelterID, PDO::PARAM_INT);
            $update->execute();
        }
    }
    createSessionAlert("", "Gespeichert", "success", "false", "2000");
    header("Location: /reports/report-shelters");
    exit();
}

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<form action="" method="post" id="updateZone" enctype="multipart/form-data">

    <div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
        <div>
            <h4 class="mb-md-0">Schnellerfassung</h4>
            <span class="text-secondary">Schutzbauten</span>
        </div>
        <div class="d-flex align-items-center flex-wrap text-nowrap">

            <button class="btn btn-primary btn-icon-text me-2" type="submit" name="quickSave">
                <i class="btn-icon-prepend mdi mdi-check-bold"></i>
                Speichern
            </button>

            <a href="/reports/report-shelters" class="btn btn-secondary btn-icon mb-md-0">
                <i class="mdi mdi-arrow-left-top"></i>
            </a>

        </div>
    </div>

    <div class="row">
        <div class="col-12 col-md-9 order-2 order-xl-1 grid-margin">

            <div class="card">
                <div class="card-header bg-primary text-white">
                    Schutzbauten
                </div>
                <div class="card-body">
                    <?php
                    try {
                        $sql = "SELECT * FROM 
                                    Shelters
                                ORDER BY 
                                    Name
                            ";

                        $stmt = $pdo->prepare($sql);
                        $stmt->execute();
                        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

                        if ($results) {
                            echo '<div class="table-responsive">';
                            echo "<table id='dTableAdminZones' class='table table-bordered'>";
                            echo '<thead>
                                <tr>
                                    <th>Bezeichnung</th>
                                    <th width="15%" class="text-center">Telefon</th>
                                    <th width="15%" class="text-center">Funk</th>
                                    <th width="20%" class="text-center">Personen</th>
                                </tr>
                            </thead>';

                            foreach ($results as $row) {
                                echo "<tr>";
                                echo "<td class='fw-bold'>{$row['Name']}</td>";
                                echo "<td class='text-center'>{$row['Phone']}</td>";
                                echo "<td class='text-center'>{$row['Radio']}</td>";
                                echo '<td class="text-center" style="padding: .60rem .85rem;"><input type="number" class="form-control text-center" name="qty-shelter-' . $row['ID'] . '" value="' . $row['QuickQty'] . '" placeholder="Anzahl"></td>';
                                echo "</tr>";
                            }

                            echo "</table>";
                            echo '</div>';
                        } else {
                            echo '<div class="alert alert-warning mb-0" role="alert">
                                <i class="mdi mdi-alert-box-outline"></i>
                                Es sind keine Schutzbauten vorhanden.
                            </div>
                            ';
                        }
                    } catch (PDOException $e) {
                        echo "Datenbankfehler: " . $e->getMessage();
                    }
                    ?>
                </div>
            </div>

        </div>

        <div class="col-12 col-md-3 order-1 order-xl-2 grid-margin">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    Information
                </div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        Über diese Funktion kann im <strong>Alarmfall</strong> eine <strong>schnelle Übersicht</strong>
                        der <strong>Personenzahlen</strong> in den jeweiligen <strong>Schutzbauten</strong> erfasst
                        werden. Diese dient der <strong>Lageeinschätzung</strong>, ersetzt jedoch keine exakte Zuordnung
                        einzelner Personen zu einem konkreten Schutzbau.
                    </li>
                </ul>
            </div>
        </div>


    </div>


    <!-- Modal : Schutzbauten Zurücksetzen -->
    <div class="modal fade" id="modalResetShelters" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form action="" method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title">Zurücksetzen</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <p class="fw-bold mb-2">
                            Durch diesen Vorgang werden alle bereits erfassten Personen wieder
                            ausgetragen.
                        </p>
                        <p>Der Vorgang kann nicht rückgängig gemacht werden.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
                        <button type="submit" class="btn btn-icon-text btn-danger" name="resetShelters">
                            <i class="btn-icon-prepend mdi mdi-restore"></i>
                            Zurücksetzen
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</form>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>